<?php
include 'config.php';
require_once 'providerMessaging.php';  // Include functions to interact with WhatsApp
include_once 'speed_up_handler.php';  // Assuming this file includes getOrderStatus and sendWhatsAppMessage functions

function handleSecondTimeComplaint($conn, $number, $orderIds, $originalMessage) {
    $statusGroups = [];  // Groups orders by status for user messages
    $providerMessages = [];  // Groups external IDs by provider and status for provider messages

    foreach ($orderIds as $orderId) {
        $status = getOrderStatus($orderId);
        $details = getProviderDetailsByOrderId($conn, $orderId);  // Fetch provider name and external_id

        if (!$details) {
            continue;  // Skip if no details are found
        }

        $providerName = $details['providerName'];
        $externalId = $details['externalId'];
        $groupId = getWhatsAppGroupIdByProviderName($conn, $providerName);

        // Grouping for user messages
        if (!isset($statusGroups[$status])) {
            $statusGroups[$status] = [];
        }
        $statusGroups[$status][] = $orderId;

        // Grouping for provider messages
        $providerKey = $providerName . '|' . $status;  // Unique key for grouping
        if (!isset($providerMessages[$providerKey])) {
            $providerMessages[$providerKey] = [
                'externalIds' => [],
                'groupId' => $groupId,
                'message' => determineProviderMessageByStatuss($status)
            ];
        }
        $providerMessages[$providerKey]['externalIds'][] = $externalId;
    }

    // Send consolidated messages to users based on status
    foreach ($statusGroups as $status => $ids) {
        $idsString = implode(', ', $ids);
        $userMessage = determineUserMessageByStatuss($status, "Order IDs $idsString");
        sendWhatsAppMessage($number, $userMessage);
    }

    // Send consolidated messages to providers
    foreach ($providerMessages as $key => $info) {
        if ($info['groupId']) {
            $externalIdsString = implode(', ', $info['externalIds']);
            $providerMessage = "Immediate action required for Order IDs $externalIdsString, " . $info['message'];
            sendGroupMessage($info['groupId'], $providerMessage);
        }
    }
}

function determineUserMessageByStatuss($status, $orderPhrase) {
    switch ($status) {
        case 'completed':
        case 'canceled':
            return "$orderPhrase is already marked as '$status'. No further action is required.";
        case 'fail':
        case 'error':
            return "Your $orderPhrase requires urgent attention and is being reviewed immediately.";
        default:
            return "Your $orderPhrase is being processed for urgent escalation.";
    }
}

function determineProviderMessageByStatuss($status) {
    switch ($status) {
        case 'fail':
        case 'error':
            return "which is currently unresolved and requires immediate attention.";
        default:
            return "has been unresolved for over 12 hours and needs urgent escalation.";
    }
}

// Usage example, assuming $conn is already available
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['orderIds']) && isset($_POST['number']) && isset($_POST['message'])) {
    handleSecondTimeComplaint($conn, $_POST['number'], explode(',', $_POST['orderIds']), $_POST['message']);
}
?>
