<?php
include 'config.php'; // Include global configuration settings

function routeMessage($conn, $number, $message, $timestamp) {
    // Normalize the message to lowercase for easier matching
    $normalizedMessage = strtolower($message);

    // Determine the type of complaint based on message content and dynamically include the handler
    if (preg_match('/(speed up|faster)/', $normalizedMessage)) {
        require_once 'handlers/speed_up_handler.php';
        handleSpeedUp($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(cancel|termination|stop order)/', $normalizedMessage)) {
        require_once 'handlers/cancel_handler.php';
        handleCancel($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(refill|top up)/', $normalizedMessage)) {
        require_once 'handlers/refill_handler.php';
        handleRefill($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(start|hasn\'t begun)/', $normalizedMessage)) {
        require_once 'handlers/not_started_handler.php';
        handleNotStarted($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(less delivery|short delivered)/', $normalizedMessage)) {
        require_once 'handlers/less_delivery_handler.php';
        handleLessDelivery($conn, $number, $message, $timestamp);
    } else {
        require_once 'handlers/other_handler.php';
        handleOther($conn, $number, $message, $timestamp);
    }
}
?>
