<?php
include 'config.php';
require_once 'providerMessaging.php';  // Include functions to interact with WhatsApp
include_once 'cancel_handler.php';  // Assuming this file includes getOrderStatus and sendWhatsAppMessage functions

function handleSecondTimeComplaintCancel($conn, $number, $orderIds, $originalMessage) {
    $statusGroups = [];  // Groups orders by status for user messages
    $providerMessages = [];  // Groups external IDs by provider and status for provider messages

    foreach ($orderIds as $orderId) {
        $status = getOrderStatus($orderId);
        $details = getProviderDetailsByOrderId($conn, $orderId);  // Fetch provider name and external_id

        if (!$details) {
            continue;  // Skip if no details are found
        }

        $providerName = $details['providerName'];
        $externalId = $details['externalId'];
        $groupId = getWhatsAppGroupIdByProviderName($conn, $providerName);

        // Grouping for user messages
        if (!isset($statusGroups[$status])) {
            $statusGroups[$status] = [];
        }
        $statusGroups[$status][] = $orderId;

        // Grouping for provider messages
        $providerKey = $providerName . '|' . $status;  // Unique key for grouping
        if (!isset($providerMessages[$providerKey])) {
            $providerMessages[$providerKey] = [
                'externalIds' => [],
                'groupId' => $groupId,
                'message' => determineProviderMessageByStatuss($status)
            ];
        }
        $providerMessages[$providerKey]['externalIds'][] = $externalId;
    }

    // Send consolidated messages to users based on status
    foreach ($statusGroups as $status => $ids) {
        $idsString = implode(', ', $ids);
        $userMessage = determineUserMessageByStatuss($status, "Order IDs $idsString");
        sendWhatsAppMessage($number, $userMessage);
    }

    // Constants for group IDs
define('ERROR_GROUP_IDD', '120363376465503407@g.us');  // Your specified group ID for errors
define('SPECIAL_GROUP_IDD', '120363373234328549@g.us');  // Group ID that requires provider name in the message

// Send messages to providers based on grouped status and provider
foreach ($providerMessages as $key => $info) {
    list($providerName, $status) = explode('|', $key);

    // Determine the message content based on status
    $providerMessageContent = determineProviderMessageByStatuss($status);
    
    // If no message should be sent (e.g., null returned for 'complete'), skip this iteration
    if ($providerMessageContent === null) {
        error_log("No action needed or message skipped for provider: " . $providerName . " with status: " . $status);
        continue;
    }

    if ($status === 'fail' || $status === 'error') {
        // Use order IDs for fail or error messages
        $idsString = implode(', ', $info['orderIds']);  // Ensure these are the correct order IDs
        $providerMessage = $providerMessageContent . " : " . $idsString . ".";
        sendGroupMessage(ERROR_GROUP_IDD, $providerMessage);
    } else {
        // First, construct the basic provider message
        $externalIdsString = implode(', ', $info['externalIds']);
        $providerMessage = $providerMessageContent . $externalIdsString . " Urgent cancel";

    // Then, check if the group ID is the special one and prepend the provider name if necessary
    if ($info['groupId'] === SPECIAL_GROUP_IDD) {
    $providerMessage = "Provider " . $providerName . " : " . $providerMessage;
    }

    // Finally, send the message to the designated group
     if ($info['groupId']) {
        sendGroupMessage($info['groupId'], $providerMessage);
    } else {
        error_log("No group ID found for provider: " + $providerName);
      }
    }
  }
}

function determineUserMessageByStatuss($status, $orderPhrase) {
    switch ($status) {
        case 'completed':
        case 'canceled':
            return "$orderPhrase is already marked as $status.";
        case 'fail':
        case 'error':
            return "Sorry for delay, your $orderPhrase added for urgent cancelation.";
        default:
            return "Sorry for delay, your $orderPhrase added for cancelation immediatly.";
    }
}

function determineProviderMessageByStatuss($status) {
    switch ($status) {
        case 'completed':
        case 'canceled':
        case 'partial':
            return null;
        case 'fail':
            return "Cancel For Fail";
        case 'error':
            return "Cancel For Error";
        default:
            return "Sending request for second time ";
    }
}

// Usage example, assuming $conn is already available
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['orderIds']) && isset($_POST['number']) && isset($_POST['message'])) {
    handleSecondTimeComplaintCancel($conn, $_POST['number'], explode(',', $_POST['orderIds']), $_POST['message']);
}
?>
