<?php
include 'config.php'; // Include global configuration settings

// List of provider group numbers or identifiers to ignore
$ignoredGroupIds = [
    '120363102124253451@g.us',
    '120363390511357243@g.us',
    '120363389575247348@g.us',
    '120363357350605044@g.us',
    '120363047171934208@g.us',
    '120363150881590083@g.us',
    '120363347345926443@g.us',
    '120363210945792357@g.us',
    '120363223335287440@g.us',
    '120363347884023068@g.us',
    '120363297545374946@g.us',
    '120363290453528634@g.us',
    '120363345017969017@g.us',
    '120363143572715257@g.us',
    '120363378282662737@g.us',
    '120363130702478921@g.us',
    '120363330461764071@g.us',
    '120363351333706033@g.us',
    '120363384702038603@g.us',
    '120363389729279425@g.us',
    '120363372305896623@g.us',
    '120363347544603110@g.us',
    '120363375674948108@g.us',
    '120363257386317864@g.us',
    '120363374447422084@g.us',
    '120363210933523255@g.us',
    '120363356193199724@g.us',
    '120363247180502838@g.us',
    '120363389558574532@g.us',
    '120363248994842083@g.us',
    '120363147252086265@g.us',
    '120363212336115194@g.us'
];

function routeMessage($conn, $number, $message, $timestamp) {
    global $ignoredGroupIds; // Bring the global variable into scope
    // Check if the message is from an ignored group before processing
    if (in_array($number, $ignoredGroupIds)) {
        error_log("Message from ignored group $number: $message");
        return; // Do not process messages from ignored groups
    }
    
    // Normalize the message to lowercase for easier matching
    $normalizedMessage = strtolower($message);

    // Determine the type of complaint based on message content and dynamically include the handler
    if (preg_match('/(speed up|faster)/', $normalizedMessage)) {
        require_once 'handlers/speed_up_handler.php';
        handleSpeedUp($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(cancel|termination|stop order)/', $normalizedMessage)) {
        require_once 'handlers/cancel_handler.php';
        handleCancel($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(refill|top up)/', $normalizedMessage)) {
        require_once 'handlers/refill_handler.php';
        handleRefill($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(start|hasn\'t begun)/', $normalizedMessage)) {
        require_once 'handlers/not_started_handler.php';
        handleNotStarted($conn, $number, $message, $timestamp);
    } elseif (preg_match('/(less delivery|short delivered)/', $normalizedMessage)) {
        require_once 'handlers/less_delivery_handler.php';
        handleLessDelivery($conn, $number, $message, $timestamp);
    } else {
        require_once 'handlers/other_handler.php';
        handleOther($conn, $number, $message, $timestamp);
    }
}
?>
