# Project Guide for Apex SMM WhatsApp Automation Bot

## Overview

This document provides an in-depth look at the architecture and operational flow of the Apex SMM WhatsApp Automation Bot. The bot automates handling user complaints via WhatsApp based on specific criteria and time rules.

## System Components

1. **Endpoint**: Receives incoming messages from users. All messages will send to router file.

2. **Router**: Directs the incoming complaints to the appropriate handler files based on the type of complaint (e.g., refill, speedup, cancel).

3. **Handlers**:
   - `handler files`: Processes new complaints or those not addressed within three hours.
   - `second_time_handler files`: Handles complaints that are revisited or flagged for follow-up.

4. **API Integration**:
   - Communicates with external APIs `/api.php`to update the database with new orders.
   - Checks order status and updates customer records accordingly.

5. **Response Generation**:
   - Based on the order status and type of complaint, generates appropriate messages to send back to users.
   - Notifies the providers' group about the actions taken or required.

## Operational Flow

1. **Message Reception**: Messages are received at the Endpoint and passed to the Router.

2. **Complaint Routing**: Depending on the content, the Router identifies the complaint type and forwards it to the respective handler.

3. **Processing Logic**:
   - If a complaint is marked as in-progress within the last three hours, the user is informed accordingly.
   - New or older complaints are processed to initiate or follow up on actions.

4. **Database Interaction**:
   - All complaint data is logged.
   - Order statuses are updated and checked against the database.

5. **Feedback to Users**:
   - Responses are crafted based on the latest order status and sent back via WhatsApp.

6. **Action to Provider**:
   - Responses are crafted based on the order to provider for action via WhatsApp.

## Handler Files

### First Time Handlers
- **Refill Handler**: `refill_handler.php`
  - Handles initial complaints regarding refill issues.
- **Speed Up Handler**: `speed_up_handler.php`
  - Manages complaints aimed at speeding up ongoing processes.
- **Cancel Handler**: `cancel_handler.php`
  - Processes requests to cancel existing orders.
- **Less Delivery Handler**: `less_delivery_handler.php`
  - Addresses complaints about less delivery than ordered.
- **Not Started Handler**: `not_started_handler.php`
  - Deals with complaints about services not starting as expected.

### Second Time Handlers
- **Cancel Complaint**: `handle_second_time_complaint_cancel.php`
  - Manages follow-up requests for cancellation.
- **Less Complaint**: `handle_second_time_complaint_less.php`
  - Addresses repeated concerns about less delivery.
- **Not Started Complaint**: `handle_second_time_complaint_not.php`
  - Handles additional complaints regarding services not starting.
- **Refill Complaint**: `handle_second_time_complaint_refill.php`
  - Manages second-time refill-related complaints.
- **Speed Complaint**: `handle_second_time_complaint_speed.php`
  - Processes follow-up complaints about speeding up services.

All handlers are designed to ensure efficient and responsive management of complaints, providing a systematic approach to customer queries and issues.

## Contact Information

For more detailed information or inquiries, please contact:

**Mr. Farhan**
Email: roarfarhan@gmail.com

Feel free to reach out with any questions or if you need further clarification on the operational aspects of the WhatsApp Automation Bot.

