<?php
include 'config.php';
require_once 'providerMessaging.php';  
include_once 'not_started_handler.php';  

function handleSecondTimeComplaintNot($conn, $number, $orderIds, $originalMessage) {
    $statusGroups = [];  
    $providerMessages = [];  

    foreach ($orderIds as $orderId) {
        $status = getOrderStatus($orderId);
        $details = getProviderDetailsByOrderId($conn, $orderId);  

        if (!$details) {
            continue;  
        }

        $providerName = $details['providerName'];
        $externalId = $details['externalId'];
        $groupId = getWhatsAppGroupIdByProviderName($conn, $providerName);

        
        if (!isset($statusGroups[$status])) {
            $statusGroups[$status] = [];
        }
        $statusGroups[$status][] = $orderId;

        
        $providerKey = $providerName . '|' . $status;  
        if (!isset($providerMessages[$providerKey])) {
            $providerMessages[$providerKey] = [
                'externalIds' => [],
                'groupId' => $groupId,
                'message' => determineProviderMessageByStatuss($status)
            ];
        }
        $providerMessages[$providerKey]['externalIds'][] = $externalId;
    }

    
    foreach ($statusGroups as $status => $ids) {
        $idsString = implode(', ', $ids);
        $userMessage = determineUserMessageByStatuss($status, "Order IDs $idsString");
        sendWhatsAppMessage($number, $userMessage);
    }

    
define('ERROR_GROUP_IDD', '120363376465503407@g.us');  
define('SPECIAL_GROUP_IDD', '120363373234328549@g.us');  


foreach ($providerMessages as $key => $info) {
    list($providerName, $status) = explode('|', $key);

    
    $providerMessageContent = determineProviderMessageByStatuss($status);
    
    
    if ($providerMessageContent === null) {
        error_log("No action needed or message skipped for provider: " . $providerName . " with status: " . $status);
        continue;
    }

    if ($status === 'fail' || $status === 'error') {
        
        $idsString = implode(', ', $info['orderIds']);  
        $providerMessage = $providerMessageContent . " : " . $idsString . ".";
        sendGroupMessage(ERROR_GROUP_IDD, $providerMessage);
    } else {
        
        $externalIdsString = implode(', ', $info['externalIds']);
        $providerMessage = $providerMessageContent . $externalIdsString . " Urgent start";

    
    if ($info['groupId'] === SPECIAL_GROUP_IDD) {
    $providerMessage = "Provider " . $providerName . " : " . $providerMessage;
    }

    
     if ($info['groupId']) {
        sendGroupMessage($info['groupId'], $providerMessage);
    } else {
        error_log("No group ID found for provider: " + $providerName);
      }
    }
  }
}

function determineUserMessageByStatuss($status, $orderPhrase) {
    switch ($status) {
        case 'completed':
        case 'canceled':
            return "$orderPhrase is already marked as $status.";
        case 'fail':
        case 'error':
            return "Sorry for delay, your $orderPhrase will start immediately.";
        default:
            return "Sorry for delay, your $orderPhrase will start immediately.";
    }
}

function determineProviderMessageByStatuss($status) {
    switch ($status) {
        case 'completed':
        case 'canceled':
        case 'partial':
            return null;
        case 'fail':
            return "Urgent Start For Fail";
        case 'error':
            return "Urgent Start For Error";
        default:
            return "Sending request for second time ";
    }
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['orderIds']) && isset($_POST['number']) && isset($_POST['message'])) {
    handleSecondTimeComplaintNot($conn, $_POST['number'], explode(',', $_POST['orderIds']), $_POST['message']);
}
?>
