<?php
// Get the JSON payload
$data = json_decode(file_get_contents('php://input'), true);

// Extract data
$number = $data['number'];
$message = $data['message'];
$timestamp = $data['timestamp'];

// Log the message (for testing)
file_put_contents('messages.log', "Number: $number, Message: $message, Timestamp: $timestamp\n", FILE_APPEND);

// Respond to confirm receipt immediately
ignore_user_abort(true); // Crucial to keep the script running after the client disconnects
header('Content-Type: application/json');
echo json_encode(['status' => 'success']);
if (function_exists('fastcgi_finish_request')) {
    fastcgi_finish_request(); // Ends request and flushes all response data to the client
}

// After sending the response, forward the data to the router for processing
require_once 'router.php';
require_once 'config.php';
routeMessage($conn, $number, $message, $timestamp);
?>

