<?php
include 'config.php';  // Include configuration for database and API keys

// Check for POST request to handle incoming data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Receive order IDs and complaint type from the handler
    $orderIds = $_POST['order_ids']; // Comma-separated list of order IDs
    $complaintType = $_POST['complaint_type']; // Type of complaint received

    // Prix API configuration
    $apiUrl = 'https://domain.com/adminapi/v2/orders/';
    $apiKey = 'your_api_key';

    // Split the string into an array of order IDs and trim spaces
    $orderIdsArray = array_map('trim', explode(',', $orderIds));

    // Initialize arrays to collect responses and track processed order IDs
    $responses = [];
    $processedOrderIds = [];

    // Process each order ID
    foreach ($orderIdsArray as $orderId) {
        // Skip empty values
        if (empty($orderId)) continue;

        // Construct the API request URL
        $requestUrl = $apiUrl . $orderId;

        // Initialize cURL session
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $requestUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "X-Api-Key: $apiKey"
        ]);

        // Execute cURL request
        $response = curl_exec($ch);
        curl_close($ch);

        // Decode JSON response
        $data = json_decode($response, true);

        // Check if the data was successfully fetched
        if ($data && isset($data['data'])) {
            $orderData = $data['data'];

            // Update the database with fetched order details
            $stmt = $conn->prepare("
                INSERT INTO orders (id, external_id, user, charge, link, start_count, quantity, service_id, service_name, status, remains, created, last_update, provider)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ON DUPLICATE KEY UPDATE
                    charge = VALUES(charge),
                    status = VALUES(status),
                    remains = VALUES(remains),
                    last_update = VALUES(last_update)
            ");
            if ($stmt) {
                $stmt->bind_param(
                    'issdssiississs',
                    $orderData['id'],                  // id
                    $orderData['external_id'],         // external_id
                    $orderData['user'],                // user
                    $orderData['charge']['value'],     // charge
                    $orderData['link'],                // link
                    $orderData['start_count'],         // start_count
                    $orderData['quantity'],            // quantity
                    $orderData['service_id'],          // service_id
                    $orderData['service_name'],        // service_name
                    $orderData['status'],              // status
                    $orderData['remains'],             // remains
                    $orderData['created'],             // created
                    $orderData['last_update'],         // last_update
                    $orderData['provider']             // provider
                );

                // Execute the prepared statement
                if (!$stmt->execute()) {
                    error_log("Failed to insert/update order: " . $stmt->error);
                }
                $stmt->close();
            } else {
                error_log("Failed to prepare statement for orders table: " . $conn->error);
            }

            // Log the complaint in the complaints table
            $stmt = $conn->prepare("
                INSERT INTO complaints (order_id, complaint_type, created_at)
                VALUES (?, ?, NOW())
            ");
            if ($stmt) {
                $stmt->bind_param('ss', $orderId, $complaintType);
                if (!$stmt->execute()) {
                    error_log("Failed to insert complaint: " . $stmt->error);
                }
                $stmt->close();
            } else {
                error_log("Failed to prepare statement for complaints table: " . $conn->error);
            }

            // Add to processed orders and collect responses
            $processedOrderIds[] = $orderId;
            $responses[] = ['order_id' => $orderId, 'status' => 'success', 'message' => 'Order processed and logged.'];
        } else {
            // Log any errors if the API response is invalid
            $responses[] = ['order_id' => $orderId, 'status' => 'error', 'message' => 'Failed to fetch data from API or invalid response.'];
        }
    }

    // Assuming $processedOrderIds is an array of order IDs that have been processed
$processedOrderIdsParam = implode(',', $processedOrderIds);

// Prepare a success message with the processed order IDs
$responseMessage = json_encode([
    'status' => 'success',
    'message' => 'Processing completed successfully.',
    'processed_order_ids' => $processedOrderIdsParam
]);

// Set header for content-type to application/json to ensure proper handling on the client side
header('Content-Type: application/json');

// Output the response message
echo $responseMessage;

// Terminate the script to prevent further processing
exit;

}
?>
