# Apex SMM Whatsapp Automation Bot

Apex SMM Whatsapp Bot is a custom PHP project designed for specific non-commercial use under strict licensing terms. This document provides an overview of the project, installation guidelines, and usage instructions.

# Installation

This section provides the steps to install the WhatsApp Automation Bot on your hosting environment using cPanel.

## Prerequisites

Ensure you have access to:
- cPanel hosting account.
- MySQL database.

## Installation Steps

1. **Upload and Extract the ZIP File**
   - Log in to your cPanel dashboard.
   - Navigate to the File Manager under the Files section.
   - Upload the `ApexWhatsAppBot.zip` file to the desired directory (e.g., `public_html` or a subfolder within it).
   - Right-click the uploaded ZIP file and select "Extract" to unpack the files into your chosen directory.

2. **Database Setup**
   - Go to the MySQL Databases section in cPanel.
   - Create a new database and a database user, then add the user to the database with full privileges.
   - Import the provided SQL `ApexWhatsAppBot.sql` file into your new database using the phpMyAdmin tool accessible from cPanel.

3. **Configure the Bot**
   - Navigate to the extracted files in the File Manager.
   - Locate and open `config.php` for editing.
   - Update the database settings with your new database name, user, and password.
   - Save the changes.

4. **Configure Whatsapp Api & External Api**
   - Update your whatsapp api url messaging sending in all handler files (no need in second time handers).
   - Update your domain in `PassToApi` function in handlers files to send order ids in support system/database.

5. **Configure Whatsapp Api Webhook**
   - Add your `https://domain.com/endpoint.php` as your webhook to your whatsapp api.
   - Optionally, trigger a test complaint to see if the bot processes it as expected.

## Running the Bot

Once installed, the bot will automatically handle incoming messages and route them according to the predefined rules in the system.

For detailed operation and configuration guidelines, refer to the Project Documentation (PROJECT_GUIDE.md).
